/*
* Create function globlal Js Add for Creantis Vtiger 7.5 header page
* Actualizacion 2023-03-23
*/
var DEBUG=false; // => para imprimir el contenido de la funcion
var DEBUGF=true; // => para imprimir nombre de la funcion
/**
 * Simplifigar el console.log
 * ejecutar=> log("Hello world!");
 */
const { log } = console;



/**
 * Print en consola  
 * @param {Object} obj  =>valor que se imprime en consola
 * @param {string} funcion =>pasar el nombre de la funcion (opcional)
 */
const debuglog = (obj, funcion = '') =>  {
    if(funcion && DEBUGF)console.log('function:',funcion)
    if(obj && DEBUG)console.log('debug:',obj)
}



/**
 * [Simplifidar el document.querySelector]
 * @param  {[string]} selector [selector del elemento]
 * @param  {[string]} scope    [opcional elemnto del formulario]
 * @return {[elemento]}          [selector]
 */
const select = (selector, scope = document) => {
  return scope.querySelector(selector);
};


/**
 * para modificar el valor de un select2 o picklist en el campo del formulario
 * @param {string} selector => [name=campo]
 * @param {string} value => valor del campo
 * @requiere Libreria Jquery
 */
const select2value = (selector, value) => {
  value= (value)?value:'';
  $(selector).val(value); // Change the value or make some change to the internal state
  $(selector).trigger('change');
};

/**
 * [verificar si los valores de un array tiene al menos un '0']
 * @param  {[array]}  arr [valores]
 * @return {Boolean}     [true si encuentra algun 0]
 */
function hasZero(arr) {
    return arr.some(val => val === '0');
}



/**
 * [obtener los valores de una columna específica en una tabla]
 * @param  {[string]} tableId     [id de la tabla]
 * @param  {[int]} columnIndex [numero de columna a extraer]
 * @return {[array]}             [valores de la columna]
 */
const getColumnValues = (tableId, columnIndex) => {
  const table = document.getElementById(tableId);
  const tbody = table.querySelector("tbody");
  const rows = tbody.querySelectorAll("tr");

  return Array.from(rows).map(row => {
    const cells = row.querySelectorAll("td");
    return cells[columnIndex].textContent;
  });
}



/**
 * [función solo seleccionará los inputs de tipo checkbox]
 * @param  {[type]} formId [id del formulario]
 */
const checkAllInputs=(formId)=> {
  const form = document.getElementById(formId);
  const inputs = form.querySelectorAll("input");
  inputs.forEach(input => input.checked = true);
}



/**
 * [isObjectEmpty Para verificar si un objeto tiene un valor vacío en JavaScript, puedes usar la función Object.values() para obtener todos los valores del objeto y luego verificar si alguno de ellos es undefined o una cadena vacía.]
 * @param  {[type]}  obj) {             return Object.values(obj).every(val [description]
 * @return {Boolean}      [True si es vacio or false si esta lleno]
 */
const isObjectEmpty = (obj)=> {  
  return Object.values(obj).every(val => val === undefined || val === "");
}

/**
 * comprobar si un objeto tiene alguna propiedad que tenga un valor vacío
 * @param {*} obj 
 * @returns 
 */
const hasEmptyPropertyValue = (obj) => {
  return Object.values(obj).some((val) => val === undefined || val === "");
};


/**
 * [removeProperties devuelve un nuevo objeto sin las propiedades que pases por array]
 * @param  {[type]} obj   [objeto que se va copiar para eliminar las propiedades]
 * @param  {[type]} props [array con propiedades que se van a eliminar]
 * @return {[type]}       [nuevo objeto sin las propiedades ]
 */
const removeProperties=(obj, props) =>{
  const newObj = {...obj};
  for (let prop of props) {
    delete newObj[prop];
  }
  return newObj;
}



/**
 * [getFormValues Para obtener los valores de un formulario que contenga diferentes tipos de elementos, como select, input, radio y checkbox, ]
 * @param  {[string]} formid [id del formulario]
 * @return {[obj]}      [objeto]
 */
function getFormValues(formId) {
  const form = document.getElementById(formId);
  const formValues = {};
  
  Array.from(form.elements).forEach(element => {
    if (element.name && !element.disabled) {
    if (element.tagName === 'SELECT') {
      const selectedOptions = Array.from(element.options)
      .filter(option => option.selected);
  
      if (selectedOptions.length === 1) {
      const selectedOption = selectedOptions[0];
      formValues[element.name] = selectedOption.value;
  
      // Obtener los atributos data y agregarlos al objeto formValues sin el prefijo "data-"
      const attributes = Array.from(selectedOption.attributes);
      attributes.forEach(attribute => {
        if (attribute.name.startsWith('data-')) {
        const attributeName = attribute.name.replace('data-', '');
        formValues[attributeName] = attribute.value;
        }
      });
      } else if (selectedOptions.length > 1) {
      formValues[element.name] = selectedOptions.map(option => option.value);
  
      // Obtener los atributos data de cada opción seleccionada y agregarlos al objeto formValues sin el prefijo "data-"
      selectedOptions.forEach(option => {
        const attributes = Array.from(option.attributes);
        attributes.forEach(attribute => {
        if (attribute.name.startsWith('data-')) {
          const attributeName = attribute.name.replace('data-', '');
          if (!formValues[attributeName]) {
          formValues[attributeName] = [];
          }
          formValues[attributeName].push(attribute.value);
        }
        });
      });
      }
    } else if (element.type === 'checkbox' || element.type === 'radio') {
      if (element.checked) {
      if (!formValues[element.name]) {
        formValues[element.name] = [];
      }
      formValues[element.name].push(element.value);
      }
    } else {
      formValues[element.name] = element.value;
    }
    }
  });
  
  return formValues;
  }


/**
 * [asignar los valores de un objeto a los elementos de un formulario, recorre cada elemento 'name' del formulario y asigne el valor correspondiente del objeto]
 * @param  {[string]} formid [id del formulario]
 * @param  {[obj]} values [objeto]
 */
const setFormValues = (formid, values) => 
  Array.from(document.getElementById(formid).elements).forEach(element => {
    if (!values.hasOwnProperty(element.name)) return;
    if (element.type === "select-one" || element.type === "select-multiple") {
      Array.from(element.options).forEach(
        option => option.selected = values[element.name].includes(option.value)
      );
    } else if (element.type === "checkbox" || element.type === "radio") {
      element.checked = values[element.name] === element.value;
    } else {
      element.value = values[element.name];
    }
  });




/**
 * [resetForm limpia los valores de los elementos de un formulario que sean diferentes a hidden y submit]
 * @param  {[string]} formid [id del formulario]
 */
const resetForm = (formId) => {
  Array.from(document.getElementById(formId).elements).forEach((element) => {
    if (
      (element.type !== "hidden" && element.type !== "submit") // Excluir campos hidden y submit
    ) {
      if (element.type === "select-one" || element.type === "select-multiple") {
        Array.from(element.options).forEach(
          (option) => (option.selected = false)
        );
      } else if (element.type === "checkbox" || element.type === "radio") {
        element.checked = false;
      } else {
        element.value = "";
      }
    }
  });
};



/**
 * [obtenerDatosJson obtienes los datos en json desde el fetch]
 * @param  {[string]} url [description]
 * @return {[json]}     [description]
 */
const obtenerDatosJson = async (url) => {
  const response = await fetch(url);
  if (response.ok) {
      try {
        const datos = await response.json();
         return datos;
      } catch (error) {
          const response = await fetch(url);
          let text = await response.text();
          console.error(error,text);
      }
  } else {
    throw new Error("Error al obtener los datos");  
  }

};



/**
 * Cambia el formato de la fecha a YYYY-mm-dd
 * @param {'dd-mm-YYYY'} fecha [string]
 * @returns [objeto]
 */
const changeFormaFechaYearMonthDay = (fecha) =>  {
    let objDate={}
    fecha=fecha.toString();
    const [dia, mes, year] = fecha.split('-');
    objDate.yyyy_mm_dd = `${year}-${mes.padStart(2, '0')}-${dia.padStart(2, '0')}`;
    objDate.year = year
    objDate.mes = mes.padStart(2, '0')
    objDate.dia = dia.padStart(2, '0')

    objDate.date = new Date(objDate.yyyy_mm_dd);
    objDate.toISOString = new Date(objDate.yyyy_mm_dd).toISOString()
    return objDate;
  };



/**
 * Calcula los dias y semanas entre dos fechas
 * @param {'YYYY-mm-dd'} fecha1 [string]
 * @param {'YYYY-mm-dd'} fecha2 [string]
 * @returns [objeto]
 */
const calcularNumeroSemana=(fecha1, fecha2)=> {
    let objDate={}
     objDate.dateISO1 = new Date(fecha1.toString() + "T00:00:00-05:00").toISOString();
     objDate.dateISO2 = new Date(fecha2.toString() + "T00:00:00-05:00").toISOString();
     objDate.fechaDesde = new Date(objDate.dateISO1)
     objDate.fechaHasta = new Date(objDate.dateISO2)
    
    const diferenciaMs = objDate.fechaHasta - objDate.fechaDesde;
    const msEnSemana = 1000 * 60 * 60 * 24 * 7;
     objDate.semanasCompletas = Math.floor(diferenciaMs / msEnSemana);
     objDate.diasRestantes = Math.floor((diferenciaMs % msEnSemana) / (1000 * 60 * 60 * 24));
    return objDate
};



/**
 * obtienes el primer dia del año de la 'fecha'
 * @param {'YYYY-mm-dd'} fecha [string]
 * @returns {'YYYY-mm-dd'} [string] =>
 */
function primerDiaDelYear(fecha) {
    const year = fecha.split("-")[0];
    const primerDia = `${year}-01-01`;
    return primerDia;
  }



  function quitarComas(valor) {
    if (typeof valor === 'string') {
      // Reemplazar todas las comas por una cadena vacía
      return valor.replace(/,/g, '');
    } else {
      return valor;
    }
  }
  


/**
 * remueve de la lista del select2 el optgroup
 * @param {string} label nombre del label de optgroup
 */
function removeSelectOptgroup(label){
  document.querySelector(`#viewColumnsSelect > optgroup[label="${label}"]`).remove()
  //document.querySelector('#viewColumnsSelect > optgroup[label="Información de la tarea"]').remove()
}        



/**
 * Manipulacion de DOM elements para habilitar readonly bajo style vtiger
 * @param {booleano} readOnly => true || false
 * @param {element} element => select("[name=accountname]")
 */
const elementReadonly = (readOnly, element) => {
  if(element){
  element.readOnly = readOnly;
  element.style.background = readOnly ? "#eee" : "white";
  }
};



/**
 * Manipulacion de DOM elements para habilitar required
 * @param {booleano} required => true || false
 * @param {element} element => select("[name=accountname]")
 */
const elementRequired = (required, element) => {
  if(element){
    element.required = required;
      let value = element.parentNode.previousElementSibling.innerHTML
      let span = element.parentNode.previousElementSibling.querySelector('span')
    if(required && !span){
      element.parentNode.previousElementSibling.innerHTML = `${value} <span class="redColor">*</span>`;
    }
    if(!required && span){
      element.parentNode.previousElementSibling.innerHTML = value.replace(' <span class="redColor">*</span>', '');
    }
  }
};



/** 
 * Para obtener el texto de la opción seleccionada en un elemento con el atributo name
 * @param {string} selectName => 'accountname'
 */
  const getSelectedOptionText = (selectName) => {
    let selectElement = document.querySelector(`#QuickCreate`);
    if(document.querySelector(`#QuickCreate`)){
      selectElement= selectElement.querySelector(`[name='${selectName}']`);
    }else{
      selectElement = document.querySelector(`[name='${selectName}']`);
    }
    const selectedOption = selectElement.options[selectElement.selectedIndex];
    return selectedOption.text;
  }



  
  /**
   * Manipulas el input del campo relacional para pasar valores
   * @param {*} value => LLenar con el id para mandarlo por el formulario
   * @param {string} text => llenar el input con el nombre a mostrar
   * @param {Element} selector => select('campo')
   */
  const showReferenceSelection=(value,text, selector) => {
    if(!selector)return false;
    let obj={} 
    const hiddenInput = selector.parentElement.childNodes[0];
    const visibleInput = selector;
    const btnx = selector.parentElement.childNodes[2];
  
  
  
    hiddenInput.value = value;
    visibleInput.value = text;
    if(value){
    obj.disable=true
    visibleInput.setAttribute('disabled', 'disabled');
    btnx.classList.remove('hide');
    }else{
    obj.disable=false
    visibleInput.removeAttribute('disabled');
    btnx.classList.add('hide');
    }
    debuglog( obj,'showReferenceSelection');
  }
  


/**
 * Manipular el DOM de la vista segun sea el caso para el campo relacional
 *  -TRUE (verLupa,verPlus)=> para ver campo y FALSE para ocultarlo 
 *  -TRUE (input)=> disabled y FALSE para quitar el disabled
 * @param {Element} selector  => select('campo')
 * @param {Boolean} verLupa => lupa del campo relacional
 * @param {Boolean} verPlus => agregar del campo relacional
 * @param {Boolean} input => campo de texto del campo relacional
 */
const CampoRelacinaControlarDOM=(selector, verLupa = true, verPlus = true, input = true, clickX = true)=>{
  if(!selector)return false;

  const btnX = selector.parentElement.childNodes[2];
  const Lupa = selector.parentElement.childNodes[3];
  const plus = selector.parentElement.childNodes[4];


  if(!input){
    if(clickX){ 
      btnX.click();
    }else{
      btnX.classList.add('hide')
      log('paso')
    };

    selector.setAttribute('disabled', 'disabled')
    }else{
      selector.removeAttribute('disabled')
    };
  (!verLupa)?Lupa.classList.add('hide'): Lupa.classList.remove('hide');
  (!verPlus)?plus.classList.add('hide'): plus.classList.remove('hide');

}



  function buscarPalabra(cadena, palabra) {
    return cadena.toUpperCase().includes(palabra.toUpperCase());
  }



  /**
   * para sumar year a la fecha original
   * @param {'dd-mm-YYYY'} fecha [string]
   * @param {Integer} dias 
   * @returns {'dd-mm-YYYY'} + {dias}
   */
  function sumarAnios(fecha, anios) {
    // Separar la fecha en día, mes y año
    const [day, month, year] = fecha.split("-");
    const resultado = new Date(year, month - 1, day);
    resultado.setFullYear(resultado.getFullYear() + anios);
    const newYear = resultado.getFullYear();
    const newMonth = resultado.getMonth() + 1;
    const newDay = resultado.getDate();
    return `${newDay.toString().padStart(2, '0')}-${newMonth.toString().padStart(2, '0')}-${newYear.toString()}`;
  }
  
  
  
  
  

  /**
   * Voltear formato de fecha
   * @param {'YYYY-mm-dd'} fecha 
   * @returns {'dd-mm-YYYY'} + {dias}
   */
  function convertDateDayMesYear(fecha) {
    // Separar los componentes de la fecha y formatear en el orden deseado
    return fecha.split('-').reverse().join('-');
  }